<script>
  module.exports = {
    methods: {
      open() {
        this.$message('这是一条消息提示');
      },

      open2() {
        this.$message({
          message: '恭喜你，这是一条成功消息',
          type: 'success'
        });
      },

      open3() {
        this.$message({
          message: '警告哦，这是一条警告消息',
          type: 'warning'
        });
      },

      open4() {
        this.$message({
          message: '错了哦，这是一条错误消息',
          type: 'error'
        });
      },

      open5() {
        this.$message({
          showClose: true,
          message: '这是一条消息提示'
        });
      },

      open6() {
        this.$message({
          showClose: true,
          message: '恭喜你，这是一条成功消息',
          type: 'success'
        });
      },

      open7() {
        this.$message({
          showClose: true,
          message: '警告哦，这是一条警告消息',
          type: 'warning'
        });
      },

      open8() {
        this.$message({
          showClose: true,
          message: '错了哦，这是一条错误消息',
          type: 'error'
        });
      }
    }
  };
</script>

<style>
  .demo-box.demo-message {
    .el-button + .el-button {
      margin-left: 10px;
    }
  }
</style>

## Message 消息提示

反馈提示，比 Notification 更为小巧

### 基础用法

:::demo Message 在配置上与 Notification 非常类似，所以部分 options 在此不做详尽解释，文末有 options 列表，可以结合 Notification 的文档理解它们。Element 注册了一个`$message`方法用于调用，Message 可以接收一个字符串作为参数，它会被显示为正文内容。

```html
<template>
  <el-button :plain="true" @click.native="open">打开消息提示</el-button>
</template>

<script>
  export default {
    methods: {
      open() {
        this.$message('这是一条消息提示');
      }
    }
  }
</script>
```
:::

### 不同状态

Message 提供了四种类型：`success`，`info`，`warning`，`error`，由不同图标表示。

:::demo 当需要自定义更多属性时，Message 也可以接收一个对象为参数。比如，设置`type`字段可以定义不同的状态，默认为`info`。此时正文内容以`message`的值传入。
```html
<template>
  <el-button :plain="true" @click.native="open2">成功</el-button>
  <el-button :plain="true" @click.native="open3">警告</el-button>
  <el-button :plain="true" @click.native="open4">错误</el-button>
</template>

<script>
  export default {
    methods: {
      open2() {
        this.$message({
          message: '恭喜你，这是一条成功消息',
          type: 'success'
        });
      },

      open3() {
        this.$message({
          message: '警告哦，这是一条警告消息',
          type: 'warning'
        });
      },

      open4() {
        this.$message({
          message: '错了哦，这是一条错误消息',
          type: 'error'
        });
      }
    }
  }
</script>
```
:::

### 可关闭

可以设置为手动关闭的 Message

:::demo 默认的 Message 是不可以被人工关闭的，如果需要可手动关闭的 Message，可以使用`showClose`字段。此外，和 Notification 一样，Message 拥有可控的`duration`，设置`0`为不会被自动关闭，默认为 3000 毫秒。
```html
<template>
  <el-button :plain="true" @click.native="open5">消息</el-button>
  <el-button :plain="true" @click.native="open6">成功</el-button>
  <el-button :plain="true" @click.native="open7">警告</el-button>
  <el-button :plain="true" @click.native="open8">错误</el-button>
</template>

<script>
  export default {
    methods: {
      open5() {
        this.$message({
          showClose: true,
          message: '恭喜你，这是一条成功消息'
        });
      },

      open6() {
        this.$message({
          showClose: true,
          message: '警告哦，这是一条警告消息',
          type: 'warning'
        });
      },

      open7() {
        this.$message({
          showClose: true,
          message: '错了哦，这是一条错误消息',
          type: 'error'
        });
      },

      open8() {
        this.$message({
          showClose: true,
          message: '错了哦，这是一条错误消息',
          type: 'error'
        });
      }
    }
  }
</script>
```
:::

## 全局方法

element 为 Vue.prototype 添加了全局方法 $message。因此在 vue instance 中可以采用本页面中的方式调用 `Message`。

## 单独引用

单独引入 `Message`：

```javascript
import { Message } from 'element-ui';
```

此时调用方法为 `Message(options)`。

## Options
| 参数      | 说明          | 类型      | 可选值                           | 默认值  |
|---------- |-------------- |---------- |--------------------------------  |-------- |
| message | 消息文字 | string | - | - |
| type | 主题 | string | success/warning/info/error | info |
| duration | 显示时间, 毫秒。设为 0 则不会自动关闭 | number | - | 3000 |
| showClose | 是否显示关闭按钮 | boolean | - | false |
| onClose | 关闭时的回调函数, 参数为被关闭的 message 实例 | function | - | - |
